/*
 * Decompiled with CFR 0.152.
 */
package birchconfig;

import birchconfig.BirchProperties;
import birchconfig.BufferedTextInputFile;
import birchconfig.BufferedTextOutputFile;
import birchconfig.runCommand;
import birchconfig.screenMsg;
import java.util.Date;

public class customdoc {
    static runCommand runner = new runCommand();

    public customdoc() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void progressMessage(BufferedTextOutputFile logfile, String S) {
        logfile.PW.println(S);
    }

    static void makeParamFile(BirchProperties tempBP, BufferedTextOutputFile logfile) {
        BirchProperties BP = tempBP;
        BufferedTextOutputFile outfile = new BufferedTextOutputFile();
        String FN = BP.homedir + "/local/admin/newstr.param";
        if (outfile.WriteOkay(FN)) {
            logfile.PW.println("Create substitution strings for customdoc.py: ");
            try {
                outfile.PW.println("~");
                outfile.PW.println(BP.birchURL);
                outfile.PW.println(BP.birchHomeURL);
                outfile.PW.println(BP.adminEmail);
                outfile.PW.println(BP.homedir);
                outfile.PW.println(BP.adminUserid);
                outfile.PW.flush();
                outfile.FW.close();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    static boolean runCustomDoc(BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Changing HMTL documentation to correspond to local directory structure";
        logfile.PW.print("birchconfig: " + MSG + ": ");
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("customdoc.py", MSG);
        String COMMAND = "python ./customdoc.py oldURLs.param newURLs.param htmldir.param";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    static void readNewURLs(String[] newstrings) {
        BufferedTextInputFile infile = new BufferedTextInputFile();
        if (infile.OpenOkay("newURLs.param")) {
            String line = infile.nextLine();
            for (int i = 0; i <= 1; ++i) {
                newstrings[i] = line;
                line = infile.nextLine();
            }
        }
    }

    static boolean runHtmlDoc(BufferedTextOutputFile logfile) {
        boolean OKAY = true;
        String MSG = "Rebuilding program documentation pages to correspond to local directory structure";
        logfile.PW.print("birchconfig: " + MSG + ": ");
        screenMsg scr = new screenMsg();
        screenMsg.printSubHeading("htmldoc.py: ", MSG);
        String COMMAND = "python ./htmldoc.py";
        OKAY = runCommand.runCommand(COMMAND);
        if (OKAY) {
            logfile.PW.println("Succeeded");
        } else {
            logfile.PW.println("FAILED!");
        }
        return OKAY;
    }

    public static void main() {
        String userid;
        BufferedTextOutputFile logfile = new BufferedTextOutputFile();
        boolean OKAY = true;
        if (logfile.WriteOkay("../birchconfig.customdoc.log")) {
            customdoc.progressMessage(logfile, "Changing URLs in BIRCH documentation");
            Date D = new Date();
            String TimeStamp = D.toString();
            customdoc.progressMessage(logfile, TimeStamp);
            customdoc.progressMessage(logfile, "");
        }
        if ((userid = System.getProperty("user.name")).equals("psgendb")) {
            customdoc.progressMessage(logfile, "UPDATE ABORTED! - psgendb can't run customdoc.py");
            System.out.println("UPDATE ABORTED! - psgendb can't run customdoc.py");
        } else if (customdoc.runCustomDoc(logfile)) {
            BirchProperties BP = new BirchProperties();
            System.out.println("BirchProperties read. BIRCH home dir: " + BP.homedir);
            BP.loadProps("../local/admin/BIRCH.properties");
            String[] newstrings = new String[2];
            customdoc.readNewURLs(newstrings);
            BP.birchURL = newstrings[0];
            BP.birchHomeURL = newstrings[1];
            BP.writeProps("../local/admin/BIRCH.properties");
            customdoc.makeParamFile(BP, logfile);
            customdoc.runHtmlDoc(logfile);
        } else {
            customdoc.progressMessage(logfile, "Update of URLs in documentation failed.\n");
            customdoc.progressMessage(logfile, "See birchconfig.customdoc.log");
        }
        logfile.PW.close();
    }

    private void jbInit() throws Exception {
    }
}

